function [M,V,M_caracteristique,V_caracteristique]=ExerciceN2(Nbr,mu,Sigma,lambda,alpha,beta,n,mc)
p=Nbr/sum(Nbr);
[Xi]=Generer(p,mu,Sigma,lambda,alpha,beta,n);
x=0:0.0001:max(Xi);
[fhat,xi]=ksdensity(Xi,x);
f1=pdf('norm',xi,mu,Sigma);
f2=pdf('exp',xi,lambda);
f3=pdf('wbl',xi,alpha,beta);
f=p(1)*f1+p(2)*f2+p(3)*f3;
% La courbe de f thorique en bleue et la courbe de l'estimateur de f en rouge.
plot(xi,f,'b',xi,fhat,'r')

for i=1:mc
    Xi=Generer(p,mu,Sigma,lambda,alpha,beta,n);
    m(i)=mean(Xi);
    v(i)=var(Xi);
end
M=mean(m); % Moyenne des moyenne
V=mean(v); % Moyenne des variance

%Construction de l'IC de la moyenne et de la variance sous l'hypothse de
%la normalit de l'chantillon des moyennes et celui des variances.
[muHat,sigmaHat,muCI,sigmaCI] = normfit(m);
[VHat,VsigmaHat,VCI,VsigmaCI] = normfit(v);
M_caracteristique=[muHat;sigmaHat;muCI;sigmaCI]';
V_caracteristique=[VHat;VsigmaHat;VCI;VsigmaCI]';

figure
histfit((m-muHat)/sigmaHat)% cet histogramme nous permet de comparer son allure avec celui d'une loi normale
end


%La pesente fonction nous permet de gnrr un n-echantillon de f.
function [X]=Generer(p,mu,Sigma,lambda,alpha,beta,n)
for i=1:n
    u=random('unif',0,1);
    if le(u,p(1))
        y=random('norm',mu,Sigma);
        while y<0
            y=random('norm',mu,Sigma);
        end
        X(i)=y;
    elseif le(u,p(2))
        X(i)=random('exp',lambda);
    else
        X(i)=random('wbl',alpha,beta);
    end
end
end