function [X1,X2]=NaissanceEtMort(loi1,lambda,loi2,mu,x0,h,T)
[X1]=ApprocheTemps(loi1,lambda,loi2,mu,x0,h,T);
[X2]=ApprocheEvents(loi1,lambda,loi2,mu,x0,T);
end



function [X]=ApprocheEvents(loi1,lambda,loi2,mu,x0,T)
%soit t1 la date d'une naissance 
%soit t2 la date d'une Mort 
t1=generer(loi1,lambda);
t2=generer(loi2,mu);
Tsim=min(t1,t2);
X=x0;
i=1;
while Tsim<T
    if Tsim==t1
        X(i+1)=X(i)+1;
        t1=t1+generer(loi1,lambda);
    else
        X(i+1)=X(i)-1;
        t2=t2+generer(loi2,mu);
    end
    i=i+1;
    Tsim=min(t1,t2);
end
end

function X=generer(loi,a)
l=length(a);
if l==1 % La loi en question a un seul paramtre (exemple: Loi exponontielle)
    X=random(loi,a);    
elseif l==2 % La loi en question a deux paramtres (Exemple: Loi Normale)           
    X=random(loi,a(1),a(2)); 
else      % La loi en question a trois paramtres (Exemple: Loi Weibull)       
    X=random(loi,a(1),a(2),a(3));
end
end


function [X]=ApprocheTemps(loi1,lambda,loi2,mu,x0,h,T)
i=1;
t=0;
X=x0;
while t<T
    N_naissances=NbrEvents(loi1,lambda,h);
    N_Morts=NbrEvents(loi2,mu,h);
    X(i+1)=X(i)+N_naissances-N_Morts;
    t=t+h;
    i=i+1;
end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [n]=NbrEvents(loi,a,h)
n=0;
t=0;
while t<h        
    t=t+random(loi,a);
    n=n+1;
end
end